USE [NWIC_PanelMgmt]
GO

/****** Object:  UserDefinedFunction [App].[udf_AllPatientsSIDs]    Script Date: 3/23/2017 9:11:25 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE FUNCTION [App].[udf_AllPatientsSIDs] (@pid INT)
RETURNS @AllPtSIDS TABLE
   (
       PtICN VARCHAR(50),
       PtSID INT PRIMARY KEY NOT NULL,
       Sta3n SMALLINT,
       PatientIEN VARCHAR(50)
       --PtIEN VARCHAR(50)
   )
AS
--=================================================================================
--Requestor				: Non Va Coordinated Care Project
--Author                : Jerry Kohler - Northwest Innovation Center (NWIC)
--Object/SP Name		: udf_AllPatientsSIDs
--SERVER				: DNS.URL        
--Data Base				: NWIC_PanelMgmt
--Schema				: app
--Report				: N/A
--Folder				: N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-14-2016
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Returns a table containing ALL patient SIDS plus other
--                        database key data for a single patient.  This facilitates
--                        retrieving all data for a patient, regardless of what
--                        station the patient received care at.  This facilitates
--                        showing a continuum of care.
--
--Last Changed          : 03-23-2017
--Last Changed By		: Jerry Kohler - NWIC
--Reason For Change		: Change function to look at App.AllCDWPatients instead of
--                      : RDWWork.SPatient.SPatient because AllCDWPatients is much
--                      : smaller and significantly improves performance.
--=================================================================================
BEGIN
   INSERT @AllPtSIDS
      Select x.PatientICN
            ,x.PatientSID
            ,x.Sta3n
            ,x.PatientIEN
        From App.AllCDWPatients AS x
       Where x.PatientICN = (Select y.PatientICN
                               From App.AllCDWPatients y
                              Where y.PatientSID = @pid);
   RETURN

END


GO
